# ESC/POS iOS SDK Reference Guide



| Item        | Content                  |
| ----------- | ------------------------ |
| Language    | Objective-C              |
| iOS Version | iOS 6.0 and above        |
| framework   | PrinterCommand.framework |



## Update

| Content                                  | Date      |
| ---------------------------------------- | --------- |
| Coding ESC/POS Command SDK               | 2016.3.21 |
| Establishing ESC/POS SDK Reference Guide | 2016.8.25 |

[TOC]

## 1 Print Commands

### 1.1 Print and line feed

- ##### Description

  > - Prints the data in the print buffer and feeds one line, based on the current line spacing.
  > - 打印并走纸一行

- ##### Objective-C (iOS)

  ```objective-c
  - (void)printAndLineFeed;
  ```

- ##### Sample Code (Objective-C)


### 1.2 Print and return to standard mode

- ##### Description

  > - In page mode, prints all the data in the print buffer collectively and switches from page mode to standard mode.
  > - 打印并回到标准模式(页模式)

- ##### Objective-C (iOS)

  ```objective-c
  - (void)printAndReturnStandardMode;
  ```

- ##### Sample Code (Objective-C)




### 1.3 Print and carriage return

- ##### Description

  > - Executes one of the following operations.
  > - 回车

- ##### Objective-C (iOS)

  ```objective-c
  - (void)printAndCarriageReturn
  ```

- ##### Sample Code (Objective-C)




### 1.4 Print data in page mode

- ##### Description

  > - In page mode, prints the data in the print buffer collectively.
  > - 在页模式下打印数据

- ##### Objective-C (iOS)

  ```objective-c
  - (void)printDataInPageMode;
  ```

- ##### Sample Code (Objective-C)




### 1.5 Print and feed paper

- ##### Description

  > - Prints the data in the print buffer and feeds the paper n × (vertical or horizontal motion unit).
  > - 打印并走纸

- ##### Objective-C (iOS)

  ```objective-c
  - (void)printAndFeed:(NSInteger)offset;
  ```

- ##### Parameter

  | Parameter | Range    |
  | --------- | -------- |
  | offset    | 0 to 255 |

- ##### Sample Code (Objective-C)




### 1.6 Print and reverse feed

- ##### Description

  > - Prints the data in the print buffer and feeds the paper n × (vertical motion unit) in the reverse direction.
  > - 打印并回纸

- ##### Objective-C (iOS)

  ```objective-c
  - (void)printAndReverseFeed:(NSInteger)offset;
  ```

- ##### Parameter

  | Parameter | Range   |
  | --------- | ------- |
  | offset    | 0 to 48 |

- ##### Sample Code (Objective-C)




### 1.7 Print and feed lines

- ##### Description

  > - Prints the data in the print buffer and feeds n lines.
  > - 打印并向前走纸n行

- ##### Objective-C (iOS)

  ```objective-c
  - (void)printAndFeedLines:(NSInteger)lines;
  ```

- ##### Parameter

  | Parameter | Range    |
  | --------- | -------- |
  | lines     | 0 to 255 |

- ##### Sample Code (Objective-C)




### 1.8 Print and reverse feed lines

- ##### Description

  > - Prints the data in the print buffer and feeds n lines in the reverse direction.
  > - 打印并回纸n行

- ##### Objective-C (iOS)

  ```objective-c
  - (void)printAndReverseFeedLines:(NSInteger)lines;
  ```

- ##### Parameter

  | Parameter | Range  |
  | --------- | ------ |
  | lines     | 0 to 2 |

- ##### Sample Code (Objective-C)



### 1.9 Print Self Test

* ##### Description

  > * Print Self Test
  > * 打印自检页

* ##### Objective-C(iOS)

  ```
  - (void)printSelfTest;
  ```





## 2 Line Spacing Commands



### 2.1 Set default line spacing

- ##### Description

  > - Sets the line spacing to the "default line spacing."
  > - 设置默认行距

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setLineSpacingDefault;
  ```

- ##### Sample Code (Objective-C)




### 2.2 Set line spacing

- ##### Description

  > - Sets the line spacing to n × (vertical or horizontal motion unit).
  > - 设置行距

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setLineSpacing:(NSInteger)spacing;
  ```

- ##### Parameter

  | Parameter | Range    |
  | --------- | -------- |
  | spacing   | 0 to 255 |

- ##### Sample Code (Objective-C)




## 3 Character Commands

### 3.1 Cancel print data in page mode

- ##### Description

  > - In page mode, deletes all the print data in the current print area.
  > - 在页模式下取消打印数据

- ##### Objective-C (iOS)

  ```objective-c
  - (void)cancelPrint;
  ```

- ##### Sample Code (Objective-C)




### 3.2 Set right-side character spacing

- ##### Description

  > - Sets the right-side character spacing to n × (horizontal or vertical motion unit).
  > - 设置右边字符间隔

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setRightCharacterSpacing:(NSInteger)spacing;
  ```

- ##### Parameter

  | Parameter | Range    |
  | --------- | -------- |
  | spacing   | 0 to 255 |

- ##### Sample Code (Objective-C)




### 3.3 Set print mode

- ##### Description

  > - Selects the character font and styles (emphasized, double-height, double-width, and underline).
  >
  >
  > - 设置打印模式(大小字体、粗体、倍高、倍宽、下划线)

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setTextMini:(BOOL)mini
                 bold:(BOOL)bold
         doubleHeight:(BOOL)doubleHeight
          doubleWidth:(BOOL)doubleWidth
            underline:(BOOL)underline;
  ```

- ##### Sample Code (Objective-C)



### 3.4 Set/cancel user-defined character set

- ##### Description

  > 设置或取消字符设置
  >
  > Selects or cancels the user-defined character set.
  >
  > - When the LSB of `mode` is 0, the user-defined character set is canceled.
  > - When the LSB of `mode` is 1, the user-defined character set is selected.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setUserDefinedCharacterSet:(NSInteger)set;
  ```

- ##### Parameter

  | Parameter | Range    |
  | --------- | -------- |
  | mode      | 0 to 255 |

- ##### Sample Code (Objective-C)



### 3.5 Define user-defined characters

- ##### Description

  > 定义用户已设定的字符
  >
  > Defines the user-defined character pattern for the specified character codes.
  >

- ##### Objective-C (iOS)

  ```objective-c
  - (void)defineCharactersWithCodeStart:(NSInteger)codeStart
                                codeEnd:(NSInteger)codeEnd
                             horizontal:(NSInteger)horizontal
                                   data:(NSData *)data;
  ```

- ##### Parameter

- ##### Sample Code (Objective-C)



### 3.6 Turn underline mode on/off

- ##### Description

  > 下划线模式开关

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setUnderline:(NSInteger)underline;
  ```

- ##### Parameter

  - Default: 0

  | Range | Description                           |
  | ----- | ------------------------------------- |
  | 0,48  | Turns off underline mode              |
  | 1,49  | Turns on underline mode (1-dot thick) |
  | 2,50  | Turns on underline mode (2-dot thick) |

- ##### Sample Code (Objective-C)



### 3.7 Cancel user-defined characters

- ##### Description

  > - Deletes the user-defined character pattern specified by character code n.
  > - 取消用户已设定的字符

- ##### Objective-C (iOS)

  ```objective-c
  - (void)cancelUserDefinedCharacters:(NSInteger)n;
  ```

- ##### Parameter

  | Parameter | Range     |
  | --------- | --------- |
  | n         | 32 to 126 |

- ##### Sample Code (Objective-C)



### 3.8 Turn emphasized mode on/off

- ##### Description

  > 字符加粗开关
  >
  > Turns emphasized mode on or off.
  >
  > - When the LSB of `mode` is 0, emphasized mode is turned off.
  > - When the LSB of `mode` is 1, emphasized mode is turned on.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setBold:(NSInteger)bold;
  ```

- ##### Parameter

  | Parameter | Range    |
  | --------- | -------- |
  | mode      | 0 to 255 |

- ##### Sample Code (Objective-C)



### 3.9 Turn double-strike mode on/off

- ##### Description

  > 字符黑体字开关
  >
  > Turns double-strike mode on or off.
  >
  > - When the LSB of `mode` is 0, double-strike mode is turned off.
  > - When the LSB of `mode` is 1, double-strike mode is turned on.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setDoubleStrike:(NSInteger)doubleStrike;
  ```

- ##### Parameter

  | Parameter | Range    | Default |
  | --------- | -------- | ------- |
  | mode      | 0 to 255 | 0       |

- ##### Sample Code (Objective-C)



### 3.10 Set character font

- ##### Description

  > 设置字符字体

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setCharacterFont:(NSInteger)font;
  ```

- ##### Parameter

  | Range | Description   |
  | ----- | ------------- |
  | 0, 48 | Font A        |
  | 1, 49 | Font B        |
  | 2, 50 | Font C        |
  | 97    | Extended Font |

- ##### Sample Code (Objective-C)



### 3.11 Set an international character set

- ##### Description

  > 设置国际字符
  >
  > Selects an international character set n as follows:

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setInternationalCharacterSet:(NSInteger)set;
  ```

- ##### Parameter

  | Range | Country            |
  | ----- | ------------------ |
  | 0     | U.S.A.             |
  | 1     | France             |
  | 2     | Germany            |
  | 3     | U.K.               |
  | 4     | Denmark I          |
  | 5     | Sweden             |
  | 6     | Italy              |
  | 7     | Spain              |
  | 8     | Japan              |
  | 9     | Norway             |
  | 10    | Denmark II         |
  | 11    | Spain II           |
  | 12    | Latin America      |
  | 13    | Korean             |
  | 14    | Slovenia / Croatia |
  | 15    | Chinese            |

- ##### Sample Code (Objective-C)



### 3.12 Turn 90° clockwise rotation mode on/off

- ##### Description

  > In standard mode, turns 90° clockwise rotation mode on or off for characters, using n as follows:

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setVerticalMode:(NSInteger)mode;
  ```

- ##### Parameter

  - Default : 0

  | Range | Description                              |
  | ----- | ---------------------------------------- |
  | 0, 48 | Turns off 90° clockwise rotation mode.   |
  | 1, 49 | Turns on 90° clockwise rotation mode (1-dot character spacing). |
  | 2, 50 | Turns on 90° clockwise rotation mode (1.5-dot character spacing). |

- ##### Sample Code (Objective-C)



### 3.13 Set print color

- ##### Description

  > 设置打印颜色

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setPrintColor:(NSInteger)color;
  ```

- ##### Parameter

  - Default : 0

  | Range | Description |
  | ----- | ----------- |
  | 0, 48 | Black       |
  | 1, 49 | Red         |

- ##### Sample Code (Objective-C)



### 3.14 Set character code table

- ##### Description

  > 设置字符编码表

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setCharacterCodeTable:(NSInteger)table;
  ```

- ##### Parameter

  | Range | Description                              |
  | ----- | ---------------------------------------- |
  | 0     | Page 0 [PC437 (U.S.A., Standard Europe)] |
  | 1     | Page 1 [Katakana]                        |
  | 2     | Page 2 [PC850 (Multilingual)]            |
  | 3     | Page 3 [PC860 (Portuguese)]              |
  | 4     | Page 4 [PC863 (Canadian-French)]         |
  | 5     | Page 5 [PC865 (Nordic)]                  |
  | 6     | Page 6 [Simplified Kanji, Hirakana]      |
  | 7     | Page 7 [Simplified Kanji]                |
  | 8     | Page 8 [Simplified Kanji]                |
  | 16    | Page 16 [WPC1252]                        |
  | 17    | Page 17 [PC866 (Cyrillic #2)]            |
  | 18    | Page 18 [PC852 (Latin 2)]                |
  | 19    | Page 19 [PC858 (Euro)]                   |
  | 254   | Page 254                                 |
  | 255   | Page 255                                 |

- ##### Sample Code (Objective-C)



### 3.15 Turn upside-down print mode on/off

- ##### Description

  > 颠倒打印开关
  >
  > In standard mode, turns upside-down print mode on or off.
  >
  > - When the LSB of n is 0, upside-down print mode is turned off.
  > - When the LSB of n is 1, upside-down print mode is turned on.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setUpToDownMode:(NSInteger)mode;
  ```

- ##### Parameter

  | Parameter | Range    | Default |
  | --------- | -------- | ------- |
  | mode      | 0 to 255 | 0       |

- ##### Sample Code (Objective-C)



### 3.16 Set character color

- ##### Description

  > 设置字符颜色

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setCharacterColor:(NSInteger)color;
  ```

- ##### Parameter

  | Range | Character Color |
  | ----- | --------------- |
  | 48    | None (No Print) |
  | 49    | color 1         |
  | 50    | color 2         |
  | 51    | color 3         |

- ##### Sample Code (Objective-C)



### 3.17 Set background color

- ##### Description

  > 设置背景颜色

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setBackgroundColor:(NSInteger)color;
  ```

- ##### Parameter

  | Range | Background Color |
  | ----- | ---------------- |
  | 48    | None (No Print)  |
  | 49    | color 1          |
  | 50    | color 2          |
  | 51    | color 3          |

- ##### Sample Code (Objective-C)



### 3.18 Turn shading mode on/off

- ##### Description

  > 阴影模式开关

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setShadowMode:(NSInteger)mode color:(NSInteger)color;
  ```

- ##### Parameter

  - mode

    | mode  | Description                          |
    | ----- | ------------------------------------ |
    | 0, 48 | Character shadow mode is turned on.  |
    | 1, 49 | Character shadow mode is turned off. |

  - color

    | color | shadow Color    |
    | ----- | --------------- |
    | 48    | None (No Print) |
    | 49    | color 1         |
    | 50    | color 2         |
    | 51    | color 3         |

- ##### Sample Code (Objective-C)



### 3.19 Set character size

- ##### Description

  > Selects the character height (vertical number of times normal font size) using bits 0 to 2 and selects the character width (horizontal number of times normal font size) using bits 4 to 6, as follows:

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setCharacterWidth:(NSInteger)width height:(NSInteger)height;
  ```

- ##### Parameter

  | Parameter | Range  | Default |
  | --------- | ------ | ------- |
  | width     | 0 to 8 | 0       |
  | height    | 0 to 8 | 0       |

- ##### Sample Code (Objective-C)



### 3.20 Turn white/black reverse print mode on/off

- ##### Description

  > Turns white/black reverse print mode on or off.
  >
  > - When the LSB of n is 0, white/black reverse print mode is turned off.
  > - When the LSB of n is 1, white/black reverse print mode is turned on

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setReverse:(NSInteger)reverse;
  ```

- ##### Parameter

  | Parameter | Range    | Default |
  | --------- | -------- | ------- |
  | reverse   | 0 to 255 | 0       |

- ##### Sample Code (Objective-C)



### 3.21 Turn smoothing mode on/off

- ##### Description

  > Turns smoothing mode on or off.
  >
  > - When the LSB of n is 0, smoothing mode is turned off.
  > - When the LSB of n is 1, smoothing mode is turned on.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setSmooth:(NSInteger)smooth;
  ```

- ##### Parameter

  | Parameter | Range    | Default |
  | --------- | -------- | ------- |
  | reverse   | 0 to 255 | 0       |

- ##### Sample Code (Objective-C)

### 3.22 setCharacterMultipleSize 

* ##### Desctiption

  > * Select the size of the characters in the printed data
  > * 选择字符大小 

* ##### Objective-C(iOS)

  ```
  - (void)setCharacterMultipleSize:(NSInteger)size;
  ```

* ##### Parameter

  | Parameter | Range  | Default                                                      |
  | --------- | ------ | :----------------------------------------------------------- |
  | size      | 0 to 8 | 0:2x2mm,1:3x3mm,2:4x4mm,3:6x6mm,4:8x8mm,5:9x9mm,6:10x10mm, 7:12x12mm,8:14x14mm,9:15x15mm,10:16x16mm,11:18x18mm,12:21x21mm,13:24x24mm |



### 3.23 CharacterTransform	 

* ##### Desctiption

  > + 设置字符变形
  > + setCharacterTransform 

* ##### Object-C

  ```
  - (void)setCharacterTransformMode:(NSInteger)mode;
  ```

* ##### Parameter

  | Parameter | Range | Description                                                  |
  | --------- | ----- | ------------------------------------------------------------ |
  | mode      | 0to3  | 0:close    1:Transform, sort by word    2：Transform, sort by phrase   3：Transform,sort by complete rule |


### 3.24 enterPrinterSave

* ##### Desctiption

  > * 进入断电保存模式
  > * enterPrinterSaveMode 

* ##### Object-C

  ```
  - (void)enterPrinterSaveMode;
  ```

* ##### Parameter

  ```objective-c
  此接口和退出保存的接口一起使用，适用于一些需要断电保存的指令
  This interface is used with the exit save interface for some commands that require power outage save
  eg:
  
  let esc = PTCommandESC.init()
  esc.enterPrinterSaveMode()
  esc.setCharacterCodeTable(temp)
  esc.exitPrinterSaveMode()
  PTDispatcher.share().send(esc.getCommandData())            
  ```


### 3.25 exitPrinterSave 

* ##### Desctiption

  > * 退出保存模式
  > * exitPrinterSaveMode 

* ##### Object-C

  ```
  - (void)exitPrinterSaveMode;
  ```

* ##### Parameter

  ```objective-c
  此接口和进入保存模式一起使用
  This interface is used with the enter save mode
  ```



### 3.26 getVietnamTransform 

* ##### Desctiption

  > *  获取越南语变形状态
  > * getVietnamTransform

* ##### Object-C

  ```
  - (void)getVietnamTransformMode;
  ```

* ##### Parameter

  ```objective-c
  返回值情况：
  00 00 ：close
  01 00 ：ASCII input
  02 00 ：utf-8 input
  ```


### 3.27 setVietnamTransform 

* ##### Desctiption

  > * 设置越南语变形
  > * setVietnamTransform

* ##### Object-C

  ```
  - (void)setVietnamTransformMode:(NSInteger)mode
  ```

* ##### Parameter

  | Parameter | Range | Description                    |
  | --------- | ----- | ------------------------------ |
  | mode      | 48-50 | 48:close   49:ASCII  50: utf-8 |



### 3.28 setThaiTransform

* ##### Desctiption

  > * 是否开启泰文变形
  > * setThaiTransformStatus 

* ##### Object-C

  ```objective-c
  - (void)setThaiTransformStatus:(NSInteger)status;
  ```

* ##### Parameter

  | Parameter | Range | Description     |
  | --------- | ----- | --------------- |
  | status    | 0,1   | 0:close  1:open |


### 3.29 setPrinterLanguage 

* ##### Desctiption

  > * 设置打印机语言
  > * setPrinterLanguage 

* ##### Object-C

  ```objective-c
  - (void)setPrinterLanguageMode:(NSInteger)mode;
  ```

* ##### Parameter

  | Parameter | Range | Description                                                  |
  | --------- | ----- | ------------------------------------------------------------ |
  | mode      | 0-2   | 0:  SimplifiedChinese    1: English    2: TraditionalChinese |



### 3.30 get Printer Status

* ##### Desctiption

  > * 获取打印机状态
  >
  > * getPrinterStatus

* ##### Object-C

  ```objective-c
  - (void)getPrinterStatus;
  ```

* ##### BackData

  ```objective-c
  /**
   bit7  bit6  bit5  bit4  bit3  bit2  bit1  bit0
   该接口下发后返回两个字节的数据，第一个字节表示是否开盖，第一个字节表示是否缺纸
   如果第一个字节的bit2为是0则表示开盖，反之则是合盖
   如果第二个字节的bit2和bit3都是0表示缺纸，反之则是有纸
   */
  ```

* ##### Sample

  ```objective-c
  	[ProgressHUD show:nil];
      PTCommandESC *cmd = [[PTCommandESC alloc] init];
      [cmd getPrinterStatus];
      NSMutableString *resultStatus = [[NSMutableString alloc] init];
      [[PTDispatcher share] sendData:[cmd getCommandData]];
      [[PTDispatcher share] whenReceiveData:^(NSData *data) {
          if (data != nil) {
              Byte *byte = (Byte *)data.bytes;
              if ((byte[0] & 4) == 4) {
                  [resultStatus appendString:@"开盖"];
              }else {
                  [resultStatus appendString:@"合盖"];
              }
              
              if ((byte[1] & 12) == 12) {
                  [resultStatus appendString:@"缺纸"];
              }else {
                  [resultStatus appendString:@"有纸"];
              }
              [ProgressHUD showSuccess:resultStatus];
          }
      }];
  ```


###3.31 Automatic return switch

* ##### Desctiption

  > * 自动回传开关
  >
  > * turnOnPrintStatusCallBack

* ##### Object-C

  ```objective-c
  - (void)turnOnPrintStatusCallBack:(BOOL)flag;
  ```

* ##### Parameter

  | Parameter | Range |  Description   |
  | :-------: | :---: | :------------: |
  |   flag    |  0,1  | 0:close 1:open |




## 4 Panel Button Commands


### 4.1 Enable/disable panel buttons

- ##### Description

  > Enables or disables the panel buttons.
  >
  > - When the LSB of n is 0, all buttons are enabled.
  > - When the LSB of n is 1, all buttons are disabled.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setPanelButtonMode:(NSInteger)mode;
  ```

- ##### Parameter

  | Parameter | Range    | Default |
  | --------- | -------- | ------- |
  | reverse   | 0 to 255 | 0       |

- ##### Sample Code (Objective-C)


## 5 Paper Sensor Commands


### 5.1 Set paper sensor(s) to output paper-end signals

- ##### Description

  > 是否使用纸尽传感器

- ##### Objective-C (iOS)

  ```objective-c
  - (void)enableOutPaperSensor:(BOOL)enable;
  ```

- ##### Sample Code (Objective-C)



### 5.2 Set paper sensor(s) to stop printing

- ##### Description

  > 是否使用传感器停止打印

- ##### Objective-C (iOS)

  ```objective-c
  - (void)enableStopPrintSensor:(BOOL)enable;
  ```

- ##### Sample Code (Objective-C)


## 6 Print Position Commands


### 6.1 Horizontal tab

- ##### Description

  > - Moves the print position to the next horizontal tab position.
  > - 横向跳格

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setHorizontalTab;
  ```

- ##### Sample Code (Objective-C)



### 6.2 Set absolute print position

- ##### Description

  > - Moves the print position to (xPos + yPos × 256) × (horizontal or vertical motion unit) from the left edge of the print area.
  > - 设置绝对打印位置(x、y 起始坐标)

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setAbsolutePosition:(NSInteger)position;
  ```

- ##### Parameter

  | Parameter | Range      |
  | --------- | ---------- |
  | position  | 0 to 65535 |

- ##### Sample Code (Objective-C)

### 6.3 Set horizontal tab positions

- ##### Description

  > Sets horizontal tab positions
  >
  > - n specifies the number of digits from the setting position to the left edge of the print area.
  > - k indicates the number of horizontal tab positions to be set.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setHorizontalTabPositionsData:(NSData *)data
  ```

- ##### Parameter

- ##### Sample Code (Objective-C)

### 6.4 Set print direction in page mode

- ##### Description

  > 在页模式下设置打印方向

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setPrintDirectionInPageMode:(NSInteger)direction;
  ```

- ##### Parameter

  | Range | Print Direction | Start Position |
  | ----- | --------------- | -------------- |
  | 0,48  | Left to right   | Upper left     |
  | 1,49  | Bottom to top   | Lower left     |
  | 2,50  | Right to left   | Lower Right    |
  | 3,51  | Top to Bottom   | Upper Right    |

- ##### Sample Code (Objective-C)

### 6.5 Set print area in page mode

- ##### Description

  > 在页模式下设置打印区域

- ##### Objective-C (iOS)

  ```objective-c
  - (void)pageSetPrintAreaWithXPos:(NSInteger)xPos
                              yPos:(NSInteger)yPos
                             width:(NSInteger)width
                            height:(NSInteger)height;
  ```

- ##### Parameter

  | Parameter | Range      |
  | --------- | ---------- |
  | xPos      | 0 to 65535 |
  | yPos      | 0 to 65535 |
  | width     | 0 to 65535 |
  | height    | 0 to 65535 |

- ##### Sample Code (Objective-C)

### 6.6 Set relative print position

- ##### Description

  > 设置相对打印位置

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setRelativePosition:(NSInteger)position
  ```

- ##### Parameter

  | Parameter | Range      |
  | --------- | ---------- |
  | position  | 0 to 65535 |

- ##### Sample Code (Objective-C)



### 6.7 Set justification

- ##### Description

  > 设置对齐方式

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setJustification:(NSInteger)justification;
  ```

- ##### Parameter

  | Range | Description |
  | ----- | ----------- |
  | 0, 48 | Left        |
  | 1, 49 | Center      |
  | 2, 50 | Right       |

- ##### Sample Code (Objective-C)

### 6.8 Set absolute vertical print position in page mode

- ##### Description

  > 在页模式下设置绝对垂直打印位置

- ##### Objective-C (iOS)

  ```objective-c
  - (void)pageSetAbsoluteYPos:(NSInteger)yPos;
  ```

- ##### Parameter

  | Parameter | Range      |
  | --------- | ---------- |
  | position  | 0 to 65535 |

- ##### Sample Code (Objective-C)

### 6.9 Set left margin

- ##### Description

  > 设置左边空白宽度

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setLeftMargin:(NSInteger)left
  ```

- ##### Parameter

  | Parameter | Range      |
  | --------- | ---------- |
  | left      | 0 to 65535 |

- ##### Sample Code (Objective-C)

### 6.10 Set print position to the beginning of print line

- ##### Description

  > In standard mode, moves the print position to the beginning of the print line after performing the operation specified by n.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setLinePrintPositionMode:(NSInteger)mode;
  ```

- ##### Parameter

  | Range | Description                             |
  | ----- | --------------------------------------- |
  | 0, 48 | Cancel data in the current print buffer |
  | 1, 49 | Print data in the current print buffer  |

- ##### Sample Code (Objective-C)

### 6.11 Set print area width

- ##### Description

  > 设置打印区域宽度

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setPrintAreaWidth:(NSInteger)width;
  ```

- ##### Parameter

  | Parameter | Range      |
  | --------- | ---------- |
  | width     | 0 to 65535 |

- ##### Sample Code (Objective-C)



### 6.12 Set relative vertical print position in page mode

- ##### Description

  > 在页模式下设置相对垂直打印位置
  >
  > In page mode, moves the vertical print position to `yPos` from the current position.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)pageSetRelativeYPos:(NSInteger)yPos;
  ```

- ##### Parameter

  | Parameter | Range           |
  | --------- | --------------- |
  | yPos      | -32768 to 32767 |

- ##### Sample Code (Objective-C)

## 7 Bit Image Commands

### 7.1 Set bit-image mode

- ##### Description

  > 设置位图模式
  >
  > Stores the bit image data in the print buffer using the mode specified by bit image mode m as follows:

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setImageMode:(NSInteger)mode imageWidth:(NSInteger)width data:(NSData *)data;
  ```

- ##### Parameter

  | m    | Bit image Mode        | Number of bits for vertical data | Dot density in horizontal |
  | ---- | --------------------- | -------------------------------- | ------------------------- |
  | 0    | 8-dot single-density  | 8                                | Single-density            |
  | 1    | 8-dot double-density  | 8                                | double-density            |
  | 32   | 24-dot single-density | 24                               | Single-density            |
  | 33   | 24-dot double-density | 24                               | double-density            |

- ##### Sample Code (Objective-C)

### 7.2 Print NV bit image

- ##### Description

  > 打印NV位图

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setNVBitImage:(NSInteger)imageID Mode:(NSInteger)mode;
  ```

- ##### Parameter

  - imageID

    | Parameter | Valid Range |
    | --------- | ----------- |
    | imageID   | 0 to 255    |


-   Mode

    | Mode | Description   | Scaling for horizontal | Scaling for vertical |
    | ---- | ------------- | ---------------------- | -------------------- |
    | 0,48 | Normal        | x1                     | x1                   |
    | 1,49 | Double-Width  | x2                     | x1                   |
    | 2,50 | Double-Height | x1                     | x2                   |
    | 3,51 | Quadruple     | x2                     | x2                   |

-   ##### Sample Code (Objective-C)

### 7.3 Transmit the NV graphics memory capacity.

- ##### Description

  > Transmits the entire capacity of the NV graphics area (number of bytes in the NV graphics area). 
  >
  > This function does not require ESC/POS Handshaking Protocol.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setNVGraphicsMemorySize:(NSString *)size;
  ```

- ##### Parameter

  | Send data       | Hex        | Decimal  | Data length |
  | --------------- | ---------- | -------- | ----------- |
  | Header          | 37H        | 55       | 1 byte      |
  | Identifier      | 30H        | 48       | 1 byte      |
  | Entire capacity | 30H to 39H | 48 to 57 | 1 to 8 byte |
  | NUL             | 00H        | 0        | 1 byte      |

- ##### Sample Code (Objective-C)

### 7.4 Set the reference dot density for graphics.

- ##### Description

  > 设置图形点密度标准
  >
  > Sets the reference dot density to process the graphics data or bit image data. (dpi: dots per inch) 
  >
  > - [180 dpi × 180 dpi] is selected when x=50
  > - [360 dpi × 360 dpi] is selected when x=5

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setGraphicDotDensity:(NSInteger)fn x:(NSInteger)x;
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | fn        | 1, 49       |
  | x         | 50, 51      |

- ##### Sample Code (Objective-C)

### 7.5 Print the graphics data in the print buffer.

- ##### Description

  > 打印在打印缓存的图形数据
  >
  > Prints the buffered graphics data stored by the process of `GS ( L `

- ##### Objective-C (iOS)

  ```objective-c
  - (void)printBufferGraphic:(NSInteger)fn;
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | fn        | 2, 50       |

- ##### Sample Code (Objective-C)

### 7.6 Transmit the remaining capacity of the NV graphics memory.

- ##### Description

  > 传输NV图形内存剩余容量
  >
  > Transmits the number of bytes of remaining memory (unused area) in the NV graphics area. 
  >
  > - This function does not require ESC/POS Handshaking Protocol.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)transmitGraphicRemainingMemory:(NSInteger)fn;
  ```

- ##### Parameter

  | Send data       | Hex        | Decimal  | Data length |
  | --------------- | ---------- | -------- | ----------- |
  | Header          | 37H        | 55       | 1 byte      |
  | Identifier      | 31H        | 49       | 1 byte      |
  | Unused Capacity | 30H to 39H | 48 to 57 | 1 to 8 byte |
  | NUL             | 00H        | 0        | 1 byte      |

- ##### Sample Code (Objective-C)

### 7.7 Transmit the remaining capacity of the download graphics memory.

- ##### Description

  > 传输下载图形内存的剩余容量
  >
  > Transmits the number of bytes of remaining memory (unused area) in the downloaded graphics area. 
  >
  > - This function does not require ESC/POS Handshaking Protocol.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)transmitDownloadGraphicRemainingMemory:(NSInteger)fn;
  ```

- ##### Parameter

  > See 7.6 Parameter Table

- ##### Sample Code (Objective-C)

### 7.8 Transmit the key code list for defined NV graphics.

- ##### Description

  > 传输已定义NV图形键值表
  >
  > Transmits the defined NV graphics key code list.
  >
  > - This function does require ESC/POS Handshaking Protocol.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)transmitNVGrapihcKeyCodeList;
  ```

- ##### Parameter

  | Send data             | Hex        | Decimal  | Data length  |
  | --------------------- | ---------- | -------- | ------------ |
  | Header                | 37H        | 55       | 1 byte       |
  | Identifier            | 72H        | 114      | 1 byte       |
  | Identification status | 40H to 41H | 64       | 1 byte       |
  | Data                  | 30H to 39H | 48 to 57 | 2 to 80 byte |
  | NUL                   | 00H        | 0        | 1 byte       |

- ##### Sample Code (Objective-C)

### 7.9 Delete all NV graphics data.

- ##### Description

  > 删除所有NV图形数据
  >
  > Deletes all NV graphics data that has been defined using Functions 7.10 or 7.11
  >
  > - Deleted areas are designated “Unused areas.”
  > - All key codes are designated as undefined.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)deleteNVGraphicAll
  ```

- ##### Sample Code (Objective-C)

### 7.10 Delete the specified NV graphics data.

- ##### Description

  > 删除指定的NV图形数据
  >
  > Deletes the NV graphics data defined by the key codes (kc1 and kc2).
  >
  > - Deleted areas are designated “Unused areas.”
  > - Deleted key codes are designated as undefined.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)deleteNVGraphicWithKeycode1:(NSInteger)keycode1 keycode2:(NSInteger)keycode2
  ```

- ##### Parameter

- ##### Sample Code (Objective-C)


### 7.11 Define NV graphics data

- ##### Description

  > 定义NV像素图图形数据

- ##### Objective-C (iOS)

  ```objective-c
  // Raster NV Graphic
  - (void)defineRasterNVGraphicData:(NSData *)data
                            keycode:(NSInteger)keycode
                           keycode2:(NSInteger)keycode2
                         imageWidth:(NSInteger)imageWidth
                        imageHeight:(NSInteger)imageHeight;
  // Column NV Graphic
  - (void)defineColumnNVGraphicData:(NSData *)data
                            keycode:(NSInteger)keycode
                           keycode2:(NSInteger)keycode2
                         imageWidth:(NSInteger)imageWidth
                        imageHeight:(NSInteger)imageHeight;
  ```

- ##### Parameter

  | Parameter   | Valid Range |
  | ----------- | ----------- |
  | keycode     | 32 to 126   |
  | keycode2    | 32 to 126   |
  | imageWidth  | 1 to 8182   |
  | imageHeight | 1 to 2304   |

- ##### Sample Code (Objective-C)

### 7.12 Print the specified NV graphics data.

- ##### Description

  > 打印指定的NV图形数据

- ##### Objective-C (iOS)

  ```objective-c
  - (void)printNVGraphicWithKeycode:(NSInteger)keycode
                           keycode2:(NSInteger)keycode2
                             xScale:(NSInteger)xScale
                             yScale:(NSInteger)yScale
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | keycode   | 32 to 126   |
  | keycode2  | 32 to 126   |
  | xScale    | 1 to 2      |
  | yScale    | 1 to 2      |

- ##### Sample Code (Objective-C)

### 7.13 Transmit Graphic Key Code List

- ##### Description

  > Transmit the key code list for defined download graphics.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)transmitGraphicKeycodeList
  ```

- ##### Sample Code (Objective-C)

### 7. 14 Delete Downloaded NV Graphic All

- ##### Description

  > Deletes all downloaded graphics data that has been defined using Functions 7.15 and 7.16

- ##### Objective-C (iOS)

  ```objective-c
  - (void)deleteDownloadedNVGraphicAll
  ```

- ##### Sample Code (Objective-C)

### 7.15 Delete specified download graphics data.

- ##### Description

  > 打印指定的NV图形数据

- ##### Objective-C (iOS)

  ```objective-c
  - (void)deleteDownloadedNVGraphicKeycode:(NSInteger)keycode keycode2:(NSInteger)keycode2
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | keycode   | 32 to 126   |
  | keycode2  | 32 to 126   |

- ##### Sample Code (Objective-C)

### 7. 16 Define Downloaded NV graphics data

- ##### Description

  > 定义NV像素图图形数据

- ##### Objective-C (iOS)

  ```objective-c
  - (void)defineDownloadedRasterNVGraphicData:(NSData *)data
                                      keycode:(NSInteger)keycode
                                     keycode2:(NSInteger)keycode2
                                   imageWidth:(NSInteger)imageWidth
                                  imageHeight:(NSInteger)imageHeight;

  - (void)defineDownloadedColumnNVGraphicData:(NSData *)data
                                      keycode:(NSInteger)keycode
                                     keycode2:(NSInteger)keycode2
                                   imageWidth:(NSInteger)imageWidth
                                  imageHeight:(NSInteger)imageHeight;
  ```

- ##### Parameter

  | Parameter   | Valid Range |
  | ----------- | ----------- |
  | keycode     | 32 to 126   |
  | keycode2    | 32 to 126   |
  | imageWidth  | 1 to 8182   |
  | imageHeight | 1 to 2304   |

- ##### Sample Code (Objective-C)

### 7.17 Print Downloaded NV Graphic

- ##### Description

  > Define thedownloaded graphics data (raster format).

- ##### Objective-C (iOS)

  ```objective-c
  - (void)printDownloadedNVGraphicWithKeycode:(NSInteger)keycode
                                     keycode2:(NSInteger)keycode2
                                       xScale:(NSInteger)xScale
                                       yScale:(NSInteger)yScale;
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | keycode   | 32 to 126   |
  | keycode2  | 32 to 126   |
  | xScale    | 1 to 2      |
  | yScale    | 1 to 2      |

- ##### Sample Code (Objective-C)

### 7.18 Store Graphic Data

- ##### Description

  > Store the graphics data in the print buffer

- ##### Objective-C (iOS)

  ```objective-c
  - (void)storeRasterGraphicData:(NSData *)data
                          xScale:(NSInteger)xScale
                          yScale:(NSInteger)yScale
                      imageWidth:(NSInteger)imageWidth
                     imageHeight:(NSInteger)imageHeight;

  - (void)storeColumnGraphicData:(NSData *)data
                          xScale:(NSInteger)xScale
                          yScale:(NSInteger)yScale
                      imageWidth:(NSInteger)imageWidth
                     imageHeight:(NSInteger)imageHeight;
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | xScale    | 1 to 2      |
  | yScale    | 1 to 2      |

- ##### Sample Code (Objective-C)

### 7.19 Define NV Bit Image

- ##### Description

  > Defines the NV bit image in the NV graphics area

- ##### Objective-C (iOS)

  ```objective-c
  - (void)defineNVGraphicData:(NSData *)data number:(NSInteger)number;
  ```

- ##### Parameter

- ##### Sample Code (Objective-C)

### 7.20 Define Downloaded Bit Image

- ##### Description

  > Defines the downloaded bit image in the downloaded graphic area.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)defineDownloadedImage:(NSData *)imageData
                     widthBytes:(NSInteger)widthBytes
                    heightBytes:(NSInteger)heightBytes
  ```

- ##### Parameter

  | Parameter   | Valid Range |
  | ----------- | ----------- |
  | widthBytes  | 1 to 255    |
  | heightBytes | 1 to 255    |

- ##### Sample Code (Objective-C)

### 7.21 Print Downloaded Bit Image

- ##### Description

  > Print downloaded bit image

- ##### Objective-C (iOS)

  ```objective-c
  - (void)printDownloadedImageWithMode:(NSInteger)mode
  ```

- ##### Parameter

  | Valid Range | Mode          | Width Scale | Height Scale |
  | ----------- | ------------- | ----------- | ------------ |
  | 0, 48       | Normal        | x1          | x1           |
  | 1, 49       | Double-Width  | x2          | x1           |
  | 2, 50       | Double-Height | x1          | x2           |
  | 3, 51       | Quadruple     | x2          | x2           |

- ##### Sample Code (Objective-C)

### 7.22 Print Variable Vertical Size Bit Image

- ##### Description

  > Prints a variable vertical size bit image using the scale mode. see 7.21

- ##### Objective-C (iOS)

  ```objective-c
  - (void)printVariableHeightImage:(NSData *)imageData
                             scale:(NSInteger)scale
                             width:(NSInteger)width
                            height:(NSInteger)height
  ```

- ##### Parameter

  | Parameter | Valid Range                |
  | --------- | -------------------------- |
  | scale     | 0 to 3, 49 to 51. see 7.21 |
  | width     | 1 to 4256                  |
  | height    | 1 to 16                    |

- ##### Sample Code (Objective-C)

## 8 Status Commands

### 8.1 Transmit real-time status

- ##### Description

  > 传输实时状态

- ##### Objective-C (iOS)

  ```objective-c
  - (void)transmitRealTimeStatus:(NSInteger)status
  ```

- ##### Parameter

  | Valid Range | Description                       |
  | ----------- | --------------------------------- |
  | 1           | Transmit printer status           |
  | 2           | Transmit offline status           |
  | 3           | Transmit error status             |
  | 4           | Transmit roll paper sensor status |
  | 7           | Transmit ink status               |
  | 8           | Transmit peeler status            |

- ##### Sample Code (Objective-C)

### 8.2 Transmit peripheral device status

- ##### Description

  > Transmits the peripheral device status as 1 byte of data.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)transmitPeripheralDeviceStatus:(NSInteger)status
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | status    | 0, 48       |

- ##### Sample Code (Objective-C)

### 8.3 Transmit paper sensor status

- ##### Description

  > Transmits the status of paper sensor(s) as 1 byte of data.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)transmitPaperSonsorStatus
  ```

- ##### Sample Code (Objective-C)

### 8.4 Set auto status back status

- ##### Description

  > Enables or disables basic ASB (Automatic Status Back) and specifies the status items to include, using n as follows:

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setASBStatusWithDrawer:(BOOL)drawer
                         offline:(BOOL)offline
                           error:(BOOL)error
                       rollPaper:(BOOL)rollPaper
                     panelSwitch:(BOOL)panelSwitch
  ```

- ##### Parameter

  | Parameter   | Description                      |
  | ----------- | -------------------------------- |
  | drawer      | Drawer kick-out connector status |
  | offline     | Online/offline status            |
  | error       | Error status                     |
  | rollPaper   | Roll paper sensor status         |
  | panelSwitch | Panel switch status              |

- ##### Sample Code (Objective-C)

### 8.5  Automatic Status Back (ASB) for ink

- ##### Description

  > Enables or disables the ink ASB (Automatic Status Back) and specifies the status items to include

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setInkASBWithOffline:(BOOL)offline detection:(BOOL)detection
  ```

- ##### Parameter

  | Parameter | Description                              |
  | --------- | ---------------------------------------- |
  | offline   | online/offline status of the ink mechanism |
  | detection | ink status detection                     |

- ##### Sample Code (Objective-C)

### 8.6 Transmit Status

- ##### Description

  > 传输状态

- ##### Objective-C (iOS)

  ```objective-c
  - (void)transmitStatus:(NSInteger)status
  ```

- ##### Parameter

  | Valid Range | Description                              |
  | ----------- | ---------------------------------------- |
  | 1, 49       | Transmits paper sensor status            |
  | 2, 50       | Transmits drawer kick-out connector status |
  | 4, 52       | Transmits ink status                     |

- ##### Sample Code (Objective-C)


## 9 Barcode Commands

### 9.1 HRI Font

- ##### Description

  > 设置打印条码数字字体

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setHRIFont:(NSInteger)font
  ```

- ##### Parameter

  | Valid Range | Description |
  | ----------- | ----------- |
  | 0, 48       | Font A      |
  | 1, 49       | Font B      |
  | 2, 50       | Font C      |

- ##### Sample Code (Objective-C)



### 9.2 Append Barcode

- ##### Description

  > 添加条形码

- ##### Objective-C (iOS)

  ```objective-c
  - (void)appendBarcode:(ESCBarcode)type
                   data:(NSString *)data
          justification:(NSInteger)justification
                  width:(NSInteger)width
                 height:(NSInteger)height
                    hri:(NSInteger)hri
  ```

- ##### Parameter

  - type

    ```objective-c
    typedef NS_ENUM(NSInteger, ESCBarcode) {
        
        ESCBarcodeA_UPCA    = 0,
        ESCBarcodeA_UPCE    = 1,
        ESCBarcodeA_EAN13   = 2,
        ESCBarcodeA_EAN8    = 3,
        ESCBarcodeA_CODE39  = 4,
        ESCBarcodeA_ITF     = 5,
        ESCBarcodeA_CODEBAR = 6,
        
        ESCBarcodeB_UPCA    = 65,
        ESCBarcodeB_UPCE    = 66,
        ESCBarcodeB_EAN13   = 67,
        ESCBarcodeB_EAN8    = 68,
        ESCBarcodeB_CODE39  = 69,
        ESCBarcodeB_ITF     = 70,
        ESCBarcodeB_CODEBAR = 71,
        ESCBarcodeB_CODE93  = 72,
        ESCBarcodeB_CODE128 = 73,
        ESCBarcodeB_EAN128  = 74,
        ESCBarcodeB_RSS14   = 75,
        ESCBarcodeB_RSS14T  = 76,
        ESCBarcodeB_RSSL    = 77,
        ESCBarcodeB_RSSE    = 78,
    };
    
    CODE128:
    128A(数字、大写字母、控制字符)
    128B(数字、大小写字母、控制字符)
    128C(双位数字)
    数据的第一位和第二位必须是{A或者{B或者{C
    ```

  - justification

    > See 6.7

  - width/height

    | Parameter    | Valid Range |
    | ------------ | ----------- |
    | width/height | 0 to 255    |

  - hri

    | Valid Range | Description          |
    | ----------- | -------------------- |
    | 0,48        | None                 |
    | 1,49        | Above the barcode    |
    | 2,50        | Below the barcode    |
    | 3,51        | Both above and below |

- ##### Sample Code (Objective-C)

## 10 Macro Function Commands

### 10.1 Define Macro

- ##### Description

  > Starts or ends macro definition.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)defineMacro
  ```

- ##### Sample Code (Objective-C)

### 10.2 Execute macro

- ##### Description

  > Executes a macro  `times`  times while waiting `waitTimes` × 100 msec for each macro execution, using the mode specified by `mode` as follows:
  >
  > - When `mode` = 0, the macro executes  `times`  times continuously at the interval specified by `waitTimes`.
  > - When `mode` = 1, the printer waits for the period specified by `waitTimes`, flashes the LED, and then waits for the paper feed button to be pressed. After this button is pressed, the printer executes the macro once. The printer repeats this operation `times` times.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)executeMacroWithTimes:(NSInteger)times
                      waitTimes:(NSInteger)waitTimes
                           mode:(NSInteger)mode
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | times     | 1 to 255    |
  | waitTimes | 0 to 255    |
  | mode      | 0, 1        |

- ##### Sample Code (Objective-C)

## 11 Mechanism Control Commands

### 11.1 Return Home

- ##### Description

  > Moves the print head to the standby position.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)returnHome
  ```

- ##### Sample Code (Objective-C)

### 11.2 Set Unidirectional Print Mode

- ##### Description

  > Turns unidirectional print mode on or off.
  >
  > - When the LSB of n is 0, unidirectional print mode is turned off.
  > - When the LSB of n is 1, unidirectional print mode is turned on.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setUnidirectionalPrintMode:(NSInteger)mode
  ```

- ##### Parameter

  | Valid Range | Description |
  | ----------- | ----------- |
  | 0           | OFF         |
  | 1           | ON          |
  | 0 to 255    |             |

- ##### Sample Code (Objective-C)

### 11.3 Set Partial Cut

- ##### Description

  > Executes a partial cut of the roll paper.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setPartialCut1; // one point left uncut
  - (void)setPartialCut3; // three point left uncut
  ```

- ##### Sample Code (Objective-C)

### 11.4 Set Cut Mode and Distance

- ##### Description

  > Select cut mode and cut paper

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setCutMode:(NSInteger)mode distance:(NSInteger)distance
  ```

- ##### Parameter

  | Mode Valid Range | Description                              |
  | ---------------- | ---------------------------------------- |
  | 0, 48            | Executes a full cut (cuts the paper completely). |
  | 1, 49            | Executes a partial cut (one point left uncut). |

- ##### Sample Code (Objective-C) 

## 12 Miscellaneous Commands

### 12.1 Send Real Time Request

- ##### Description

  > Responds to a request in real time from the host computer

- ##### Objective-C (iOS)

  ```objective-c
  - (void)sendRealTimeRequest:(NSInteger)request
  ```

- ##### Parameter

  | Range | Description                              |
  | ----- | ---------------------------------------- |
  | 0     | Recovers to online status when following online recovery waiting status. |
  | 1     | Recovers from a recoverable error and restarts printing from the line where the error occurred. |
  | 2     | Recovers from a recoverable error after clearing the receive and print buffers. |

- ##### Sample Code (Objective-C)

### 12.2 Generate Pulse in Real-Time

- ##### Description

  > Outputs the pulse specified by `time` to connector pin `mode` as follows in real time

- ##### Objective-C (iOS)

  ```objective-c
  - (void)generatePulseWithMode:(NSInteger)mode Time:(NSInteger)time
  ```

- ##### Parameter

  | Mode Range | Description                     |
  | ---------- | ------------------------------- |
  | 0          | Drawer kick-out connector pin 2 |
  | 1          | Drawer kick-out connector pin 5 |

- ##### Sample Code (Objective-C)

### 12.3 Execute Power-Off Sequence

- ##### Description

  > Executes the printer power-off sequence and transmits the power-off notice.
  >
  > -  Saving the maintenance counter values
  > -  Busy controlling for interface
  > -  Changing to waiting state of mechanism
  >
  > Executes power off processing (this processing depends on printer model).

- ##### Objective-C (iOS)

  ```objective-c
  - (void)executePowerOffSequence
  ```

- ##### Sample Code (Objective-C)

### 12.4 Transmit Specified Status in Real Time

- ##### Description

  > Transmits specified status in real-time as follows.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)transmitSpecifiedStatus:(NSInteger)status
  ```

- ##### Parameter

  | Status Range | Description                 |
  | ------------ | --------------------------- |
  | 1            | Transmits basic ASB status. |
  | 5            | Transmits battery status.   |

- ##### Sample Code (Objective-C)

### 12.5 Clear Buffer

- ##### Description

  > Clears all data stored in the receive buffer and the print buffer and transmits Clear response.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)clearBuffer
  ```

- ##### Sample Code (Objective-C)

### 12.6 Initialize Printer

- ##### Description

  > Clears the data in the print buffer and resets the printer modes to the modes that were in effect when the power was turned on.
  >
  > - Any macro definitions are not cleared.
  > - Offline response selection is not cleared.
  > - Contents of user NV memory are not cleared.
  > - NV graphics (NV bit image) and NV user memory are not cleared.
  > - The maintenance counter value is not affected by this command.
  > - The specifying of offline response isn’t cleared.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)initializePrinter
  ```

- ##### Parameter

- ##### Sample Code (Objective-C)

### 12.7 Set Page Mode

- ##### Description

  > 进入页模式

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setPageMode
  ```

- ##### Sample Code (Objective-C)

### 12.8 Set Standard Mode

- ##### Description

  > ​ 进入标准模式

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setStandardMode
  ```

- ##### Sample Code (Objective-C)

### 12.9 Set Density

- ##### Description

  > ​ 设置打印浓度

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setDensity:(NSInteger)density
  ```

- ##### Parameter

  | Parameter | Vaid Range         |
  | --------- | ------------------ |
  | density   | 250 to 255, 0 to 6 |

- ##### Sample Code (Objective-C)

### 12.10 Set Speed

- ##### Description

  > 设置打印速度

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setSpeed:(NSInteger)speed
  ```

- ##### Parameter

  | Parmeter | Valid Range       |
  | -------- | ----------------- |
  | speed    | 0 to 11, 48 to 57 |

- ##### Sample Code (Objective-C)

### 12 .11 Set Page Printable Area

- ##### Description

  > Printable area setting when page mode is selected

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setPageAreaWithWidth:(NSInteger)width
                        height:(NSInteger)height
                       xOffset:(NSInteger)xOffset
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | width     | 1 to 65535  |
  | height    | 1 to 65535  |
  | xOffset   | 0           |

- ##### Sample Code (Objective-C)

### 12.12 Draw Line / Rectangle

- ##### Description

  > Saves line data in the print buffer when page mode is selected.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)appendLineWithXPos:(NSInteger)xPos
                        yPos:(NSInteger)yPos
                        xEnd:(NSInteger)xEnd
                        yEnd:(NSInteger)yEnd
                        mode:(NSInteger)mode;

  - (void)appendRectWithXPos:(NSInteger)xPos
                        yPos:(NSInteger)yPos
                        xEnd:(NSInteger)xEnd
                        yEnd:(NSInteger)yEnd
                        mode:(NSInteger)mode;
  ```

- ##### Parameter

  | Parameter | Valid Range                      |
  | --------- | -------------------------------- |
  | xPos      | 0 to 431                         |
  | yPos      | 0 to 1119                        |
  | xEnd      | 0 to 431                         |
  | yEnd      | 0 to 1119                        |
  | mode      | 1 to 3 (Thin, Moderately, Thick) |

- ##### Sample Code (Objective-C)

### 12.13 Set Motion Units

- ##### Description

  > Sets the horizontal and vertical motion units to approximately 25.4/x mm {1/x"} 
  >
  > When x = 0, the default value of the horizontal motion unit is used.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setMotionUnitsWithHorizontal:(NSInteger)horizontal vertical:(NSInteger)vertical
  ```

- ##### Parameter

  | Param      | Valid Range | Default |
  | ---------- | ----------- | ------- |
  | horizontal | 0 to 255    | 0       |
  | vertical   | 0 to 255    | 0       |

- ##### Sample Code (Objective-C)

## 13 Kanji Commands

### 13.1 Set Kanji Print Mode

- ##### Description

  > Selects the character styles (double-height, double-width, and Kanji-underlined) together for multi-byte code character as follows:

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setKanjiWithReverse:(BOOL)reverse
                  doubleWidth:(BOOL)doubleWidth
                 doubleHeight:(BOOL)doubleHeight
                    underline:(BOOL)underline
  ```

- ##### Parameter

- ##### Sample Code (Objective-C)

### 13.2 Set Kanji Mode

- ##### Description

  > Selects Kanji character mode.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setKanjiMode
  ```

- ##### Sample Code (Objective-C)

### 13.3 Set Kanji Font Mode

- ##### Description

  > Selects multi-byte code character font (Kanji character font).

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setKanjiFontMode:(NSInteger)mode
  ```

- ##### Parameter

  | Valid Range | Description            |
  | ----------- | ---------------------- |
  | 0, 48       | Kanji character Font A |
  | 1, 49       | Kanji character Font B |
  | 2, 50       | Kanji character Font C |

- ##### Sample Code (Objective-C)

### 13.4 Set Kanji Underline

- ##### Description

  > Turns on or off underline mode for multi-byte code character (Kanji-underline)

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setKanjiUnderline:(NSInteger)underline
  ```

- ##### Parameter

  | Valid Range | Description                              |
  | ----------- | ---------------------------------------- |
  | 0, 48       | Turns off Kanji-underline mode           |
  | 1, 49       | Turns on Kanji-underline mode (1-dot thick) |
  | 2, 50       | Turns on Kanji-underline mode (2-dots thick) |

- ##### Sample Code (Objective-C)

### 13.5 Cancel Kanji Mode

- ##### Description

  > Cancels Kanji character mode.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)cancelKanjiMode
  ```

- ##### Sample Code (Objective-C)

### 13.6 Define Kanji

- ##### Description

  > The ranges of `first` and `second` differ, depending on models and the character code system used. The ranges of `first` and `second` for each model are as follows.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)defineKanji:(NSData *)data first:(NSInteger)first second:(NSInteger)second
  ```

- ##### Parameter

  | Models                          | first | second                |
  | ------------------------------- | ----- | --------------------- |
  | Japanese model (JIS code)       | 119   | 33 to 126             |
  | Japanese model (SHIFT JIS code) | 236   | 64 to 126, 128 to 158 |
  | Simplified Chinese              | 254   | 161 to 254            |
  | Traditional Chinese             | 254   | 161 to 254            |

- ##### Sample Code (Objective-C)

### 13.7 Set Kanji Code System

- ##### Description

  > Selects a Kanji character code system for the Japanese model as follows:

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setKanjiCodeSystem:(NSInteger)system
  ```

- ##### Parameter

  | Valid Range | Kanji          |
  | ----------- | -------------- |
  | 0, 48       | JIS code       |
  | 1, 49       | SHIFT JIS code |

- ##### Sample Code (Objective-C)

### 13.8 Set Kanji Spacing

- ##### Description

  > Sets left- and right-side spacing of the multi-byte code character `left` and `right`, respectively.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setKanjiSpacingWithLeft:(NSInteger)left right:(NSInteger)right
  ```

- ##### Parameter

  | Parameter | Valid Range | Default |
  | --------- | ----------- | ------- |
  | left      | 0 to 32     | 0       |
  | right     | 0 to 32     | 0       |

- ##### Sample Code (Objective-C)

### 13.9 Set Kanji Quadruple Mode

- ##### Description

  > Turns quadruple-size mode on or off for multi-byte code character.
  >
  > - When the LSB of n is 0, quadruple-size mode is turned off and normal size is specified
  > - When the LSB of n is 1, quadruple-size mode is turned on.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)setKanjiQuadrupleMode:(NSInteger)mode
  ```

- ##### Parameter

  | Parameter | Valid Range | Default |
  | --------- | ----------- | ------- |
  | mode      | 0 to 255    | 0       |

- ##### Sample Code (Objective-C)

### 13.10 Cancel Kanji Define

- ##### Description

  > Deletes the user-defined Kanji character pattern specified by the character codes (`first` and `second`) of the currently selected Kanji font.
  >
  > - `first` specifies the first byte of a character code for a user-defined Kanji character.
  > - `second` specifies the second byte of a character code for a user-defined Kanji character.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)cancelKanjiDefineWithFirst:(NSInteger)first second:(NSInteger)second
  ```

- ##### Parameter

  > See 13.6

- ##### Sample Code (Objective-C)

## 14 Two Dimension Code Commands

### 14.1 PDF417

- ##### Description

  > 添加 PDF417 条码

- ##### Objective-C (iOS)

  ```objective-c
  - (void)appendPDF417Data:(NSString *)data
                       row:(NSInteger)row
                    column:(NSInteger)column
                     width:(NSInteger)width
                 rowHeight:(NSInteger)rowHeight
                   eccMode:(NSInteger)eccMode
                  eccLevel:(NSInteger)eccLevel
                    option:(NSInteger)option;
                      
  - (void)transmitPDF417SymbolDataSize;
  ```

- ##### Parameter

  | Parameter | Valid Range | Description                              |
  | --------- | ----------- | ---------------------------------------- |
  | row       | 0, 3 to 90  | Set the number of rows                   |
  | column    | 0 to 30     | Set the number of columns in the data region |
  | width     | 2 to 8      | Set the width of the module              |
  | rowHeight | 2 to 8      | Set the row height                       |

  - Mode

    > Set the error correction Mode

    | Mode | Description                              |
    | ---- | ---------------------------------------- |
    | 48   | The error correction level is set by “level.” |
    | 49   | The error correction level is set by “ratio.” The ratio is `level` * 10% |

  - Level

    > Set the error correction level

    | Level | Description |
    | ----- | ----------- |
    | 48    | level 0     |
    | 49    | level 1     |
    | 50    | level 2     |

  - option

    > Select the options

    | option | Description       |
    | ------ | ----------------- |
    | 0      | standard PDF417.  |
    | 1      | truncated PDF417. |

- ##### Sample Code (Objective-C)

### 14.2 QR Code

- ##### Description

  > 设置模型

- ##### Objective-C (iOS)

  ```objective-c
  - (void)appendQRCodeData:(NSString *)data
             justification:(NSInteger)justification
                leftMargin:(NSInteger)leftMargin
                  eccLevel:(NSInteger)eccLevel
                     model:(NSInteger)model
                      size:(NSInteger)size;

  - (void)transmitQRCodeSymbolDataSize;
  ```

- ##### Parameter

  - Justification

    > See 6.7

  - Left Margin

    > See 6.9

  - ECC Level

    >  Select the error correction level

    | Level | Description | Recovery Capacity % (approx.) |
    | ----- | ----------- | ----------------------------- |
    | 48    | Level L     | 7                             |
    | 49    | Level M     | 15                            |
    | 50    | Level Q     | 25                            |
    | 51    | Level H     | 30                            |

  - Model

    | Valid Range | Description |
    | ----------- | ----------- |
    | 49          | Model 1     |
    | 50          | Model 2     |

  - Size

    > Set the size of module

    | Parameter | Valid Range |
    | --------- | ----------- |
    | size      | 1 to 16     |

- ##### Sample Code (Objective-C)

### 14.3 Maxi Code

- ##### Description

  > 添加 Maxi Code 条码

- ##### Objective-C (iOS)

  ```objective-c
  - (void)appendMaxiCodeData:(NSString *)data mode:(NSInteger)mode;
  - (void)transmitMaxiCodeSymbolDataSize;
  ```

- ##### Parameter

  | Valid Range | Description |
  | ----------- | ----------- |
  | 50          | mode 2      |
  | 51          | mode 3      |
  | 52          | mode 4      |
  | 53          | mode 5      |
  | 54          | mode 6      |

- ##### Sample Code (Objective-C)

### 14.4 RSS-2D

- ##### Description

  > 设置模型的宽度
  >
  > Sets the width of the module for RSS to n dots.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)appendRSS2Data:(NSData *)data
                    mode:(NSInteger)mode
             moduleWidth:(NSInteger)moduleWidth
                maxWidth:(NSInteger)maxWidth;

  - (void)transmitRSS2SymbolDataSize;
  ```

- ##### Parameter

  | Parameter   | Valid Range | Description                              |
  | ----------- | ----------- | ---------------------------------------- |
  | moduleWidth | 2 to 8      | Set the width of the module              |
  | maxWidth    | 2 to 8      | RSS Expanded Stacked maximum width setting |

  - Mode

    | Mode | Description                    |
    | ---- | ------------------------------ |
    | 72   | RSS-14 Stacked                 |
    | 73   | RSS-14 Stacked Omnidirectional |
    | 76   | RSS Expanded Stacked           |

- ##### Sample Code (Objective-C)

### 14.5 Composite Symbol

- ##### Description

  > Sets the width of the module for Composite Symbol to n dots.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)appendCompositeSymbolData:(NSData *)data
                               mode:(NSInteger)mode
                               type:(NSInteger)type
                        moduleWidth:(NSInteger)moduleWidth
                           maxWidth:(NSInteger)maxWidth
                            hriFont:(NSInteger)hriFont;

  - (void)transmitCompositeSymbolDataSize;
  ```

- ##### Parameter

  | Parameter   | Valid Range | Description                              |
  | ----------- | ----------- | ---------------------------------------- |
  | moduleWidth | 2 to 8      | Set the width of the module              |
  | maxWidth    | 2 to 8      | RSS Expanded Stacked maximum width setting |
  | mode        | 48, 49      |                                          |

  - HRI Font

    > Select font HRI characters

    | Valid Range | Description |
    | ----------- | ----------- |
    | 0, 48       | None        |
    | 1, 49       | Font A      |
    | 2, 50       | Font B      |
    | 3, 51       | Font C      |

  - Type (when mode = 48)

    | Type Range | Description                    |
    | ---------- | ------------------------------ |
    | 65         | EAN8                           |
    | 66         | EAN13                          |
    | 67         | UPC-A                          |
    | 68         | UPC-E 6 Digits                 |
    | 69         | UPC-E 11 Digits                |
    | 70         | RSS-14                         |
    | 71         | RSS-14 Truncated               |
    | 72         | RSS-14 Stacked                 |
    | 73         | RSS-14 Stacked Omnidirectional |
    | 74         | RSS-14 Limited                 |
    | 75         | RSS-14 Expanded                |
    | 76         | RSS Expanded Stacked           |
    | 77         | UCC/EAN 128                    |

  - Type (when mode = 49)

    | Type Range | Description |
    | ---------- | ----------- |
    | 65         | EAN13       |
    | 66         | UPC-A       |

- ##### Sample Code (Objective-C)

## 15 Customize Commands

### 15.1 Write/Read to NV user memory

- ##### Description

  > 写入/读取 NV用户内存

- ##### Objective-C (iOS)

  ```objective-c
  - (void)writeNVUserMemory:(NSInteger)address data:(NSData *)data
  - (void)readNVUserMemory:(NSInteger)address length:(NSInteger)length
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | address   | 0 to 1023   |
  | length    | 0 to 80     |

- ##### Sample Code (Objective-C)

### 15.2 Delete Record

- ##### Description

  > Deletes the record specified by the key codes (key, key2) in the NV user memory.
  >
  > - Deleted areas are designated "Unused areas".
  > - Deleted key codes are designated as undefined.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)deleteRecordWithMode:(NSInteger)mode key:(NSInteger)key key2:(NSInteger)key2
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | mode      | 0, 48       |
  | key       | 32 to 126   |
  | key2      | 32 to 126   |

- ##### Sample Code (Objective-C)

### 15.3 Store Record

- ##### Description

  > Deletes the record specified by the key codes (key, key2) in the NV user memory.
  >
  > - Deleted areas are designated "Unused areas".
  > - Deleted key codes are designated as undefined.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)storeRecordWithMode:(NSInteger)mode key:(NSInteger)key key2:(NSInteger)key2 data:(NSData *)data
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | mode      | 1, 49       |
  | key       | 32 to 126   |
  | key2      | 32 to 126   |

- ##### Sample Code (Objective-C)

### 15.4 Transmit Data In Record

- ##### Description

  > Transmits the data for the record specified by the key codes (key, key2) in the NV user memory. 
  >
  > - ESC/POS Handshaking Protocol is required for this function.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)transmitDataInRecordWithMode:(NSInteger)mode key:(NSInteger)key key2:(NSInteger)key2
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | mode      | 2, 50       |
  | key       | 32 to 126   |
  | key2      | 32 to 126   |


- ##### Sample Code (Objective-C)

### 15.5 Transmit NV Memory Used Capacity

- ##### Description

  > Transmits the number of bytes of memory used in the NV user memory. 

- ##### Objective-C (iOS)

  ```objective-c
  - (void)transmitNVMemoryUsedCapacityWithMode:(NSInteger)mode
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | mode      | 3, 51       |

- ##### Sample Code (Objective-C)

### 15.6 Transmit NV Memory Remaining Capacity

- ##### Description

  > Transmits the number of bytes of remaining memory (unused area) in the NV user memory. 

- ##### Objective-C (iOS)

  ```objective-c
  - (void)transmitNVMemoryRemainingCapacityWithMode:(NSInteger)mode
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | mode      | 4, 52       |

- ##### Sample Code (Objective-C)

### 15.7 Transmit Key Code List

- ##### Description

  > Transmits the key code list in the NV user memory.
  >
  > - ESC/POS Handshaking Protocol is required for this function.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)transmitKeyCodeListWithMode:(NSInteger)mode
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | mode      | 5, 53       |

- ##### Sample Code (Objective-C)

### 15.8 Delete all data in the NV user memory

- ##### Description

  > Deletes all data in the NV user memory.
  >
  > - All area is changed to unused area.
  > - All key codes are designated as undefined.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)deleteNVMemoryAllWithMode:(NSInteger)mode
  ```

- ##### Parameter

  | Parameter | Valid Range |
  | --------- | ----------- |
  | mode      | 6, 54       |

- ##### Sample Code (Objective-C)

### 15.9 Change User Setting Mode

- ##### Description

  > Enters the user setting mode and transmits the mode change notice.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)changeUserSettingMode
  ```

- ##### Sample Code (Objective-C)


### 15.10 End User Setting Mode

- ##### Description

  > Ends the user setting mode, and performs a software reset.

- ##### Objective-C (iOS)

  ```objective-c
  - (void)endUserSettingMode
  ```

- ##### Sample Code (Objective-C)